/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.mainhttp.impl.util;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Trie<T> {
    public final Byte2ObjectMap<Trie<T>> next = new Byte2ObjectArrayMap();
    public T content;

    public void add(Map<String, T> next) {
        next.forEach(this::add);
    }

    public void add(String key, T value) {
        if (key.isEmpty()) {
            this.content = value;
        } else {
            char c = key.charAt(0);
            if (c > '\u00ff') {
                throw new IllegalArgumentException("Invalid character: " + c);
            }
            ((Trie)this.next.computeIfAbsent((byte)c, k -> new Trie())).add(key.substring(1), value);
        }
    }

    public static <T> Trie<T> of(Map<String, T> source) {
        Trie<T> root = new Trie<T>();
        root.add(source);
        return root;
    }

    public static Trie<String> of(List<String> source) {
        return Trie.of(source.stream().collect(Collectors.toMap(Function.identity(), Function.identity())));
    }
}

